/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.api.mixin.client.gui.IGuiTextFieldMixin;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IComponentGui;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IEditNPC;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiMenuSideButton;
import noppes.npcs.client.gui.util.IGuiMenuTopButton;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcLabel;
import noppes.npcs.client.gui.util.IGuiNpcMiniWindow;
import noppes.npcs.client.gui.util.IGuiNpcSlider;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.IKeyListener;
import noppes.npcs.client.gui.util.ISliderListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import org.lwjgl.input.Mouse;

public class GuiNpcMiniWindow
extends GuiNPCInterface
implements IComponentGui,
IGuiNpcMiniWindow,
ITextfieldListener,
ISliderListener,
ICustomScrollListener,
IKeyListener {
    private final IEditNPC parent;
    private IComponentGui point;
    public int id;
    public int mousePressX;
    public int mousePressY;
    private int colorLine = 7078143;
    public boolean hovered = false;
    public boolean isMoving = false;
    public boolean visible = true;
    public String title;
    public Object[] objs = null;
    private final List<String> hoverText = new ArrayList<String>();

    public GuiNpcMiniWindow(IEditNPC gui, int id, int x, int y, int width, int height, String title) {
        this.parent = gui;
        this.id = id;
        this.guiLeft = x;
        this.guiTop = y;
        this.xSize = width;
        this.ySize = height + 12;
        this.title = new TextComponentTranslation(title, new Object[0]).func_150254_d();
        this.setBackground("bgfilled.png");
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        if (!this.hovered) {
            return;
        }
        if (button.getID() == 2500) {
            this.parent.closeMiniWindow(this);
            this.visible = false;
        } else if (this.buttons.containsKey(button.getID())) {
            this.parent.buttonEvent(button);
        }
    }

    @Override
    public void render(IEditNPC gui, int mouseX, int mouseY, float partialTicks) {
        double base;
        double xc;
        double yc;
        double dist;
        if (!this.visible) {
            this.hovered = false;
            return;
        }
        this.hovered = this.isMouseHover(mouseX, mouseY, this.guiLeft, this.guiTop, this.xSize, this.ySize);
        if (this.hovered && !this.hoverText.isEmpty()) {
            gui.setHoverText(this.hoverText);
        }
        if (this.point != null && (dist = Math.sqrt(((double)mouseY - (yc = (double)this.guiTop + (double)this.ySize / 2.0)) * ((double)mouseY - yc) + ((double)mouseX - (xc = (double)this.guiLeft + (double)this.xSize / 2.0)) * ((double)mouseX - xc))) <= (base = Math.sqrt(Math.pow(this.xSize, 2.0) + Math.pow(this.ySize, 2.0)) / 2.0) * 2.0) {
            double a = -1.0 / (2.0 * base - base);
            double b = -2.0 * a * base;
            float alpha = (float)(a * dist + b);
            if (alpha < 0.0f) {
                alpha = 0.0f;
            } else if (alpha > 1.0f) {
                alpha = 1.0f;
            }
            int[] cr = this.point.getCenter();
            int color = this.colorLine + ((int)(alpha * 255.0f) << 24);
            this.parent.addLine(cr[0], cr[1], this.guiLeft + this.xSize / 2, this.guiTop + this.ySize / 2, color, 2);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.isMoving && Mouse.isButtonDown((int)0)) {
            int x = mouseX - this.mousePressX;
            int y = mouseY - this.mousePressY;
            if (x != 0 || y != 0) {
                this.moveOffset(x, y);
                this.mousePressX = mouseX;
                this.mousePressY = mouseY;
            }
        } else {
            this.isMoving = false;
        }
        if (this.hasSubGui() || !CustomNpcs.ShowDescriptions || this.hoverMiniWin) {
            return;
        }
        for (IComponentGui component : this.components) {
            if (!(component instanceof GuiButton && ((GuiButton)component).func_146115_a() || component instanceof GuiNpcTextField && component.isHovered() || component instanceof GuiCustomScroll && ((GuiCustomScroll)component).hovered) && (!(component instanceof GuiNpcLabel) || !((GuiNpcLabel)component).hovered)) continue;
            this.parent.setMiniHoverText(this.id, component);
        }
    }

    @Override
    public void postDrawBackground() {
        GuiNpcMiniWindow.drawTopRect(this.guiLeft + 3, this.guiTop + 3, this.guiLeft + this.xSize - 3, this.guiTop + 11, this.field_73735_i, this.colorLine + -268435456, this.colorLine + 0x40000000);
        this.func_73731_b(this.field_146289_q, this.title, this.guiLeft + 4, this.guiTop + 3, CustomNpcs.MainColor.getRGB());
    }

    public void moveOffset(int x, int y) {
        this.guiLeft += x;
        this.guiTop += y;
        for (IGuiNpcButton b : this.buttons.values()) {
            b.setLeft(b.getLeft() + x);
            b.setTop(b.getTop() + y);
        }
        for (IGuiNpcLabel l : this.labels.values()) {
            l.setLeft(l.getLeft() + x);
            l.setTop(l.getTop() + y);
        }
        for (IGuiCustomScroll s : this.scrolls.values()) {
            s.setLeft(s.getLeft() + x);
            s.setTop(s.getTop() + y);
        }
        for (IGuiMenuSideButton sb : this.sideButtons.values()) {
            sb.setLeft(sb.getLeft() + x);
            sb.setTop(sb.getTop() + y);
        }
        for (IGuiNpcSlider sl : this.sliders.values()) {
            sl.setLeft(sl.getLeft() + x);
            sl.setTop(sl.getTop() + y);
        }
        for (IGuiNpcTextField t : this.textFields.values()) {
            t.setLeft(t.getLeft() + x);
            t.setTop(t.getTop() + y);
        }
        for (IGuiMenuTopButton tb : this.topButtons.values()) {
            tb.setLeft(tb.getLeft() + x);
            tb.setTop(tb.getTop() + y);
        }
        for (IGuiNpcMiniWindow mw : this.miniWindows.values()) {
            mw.setLeft(mw.getLeft() + x);
            mw.setTop(mw.getTop() + y);
        }
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (i == 15 && GuiNpcTextField.isActive() && this.textFields.containsValue(GuiNpcTextField.activeTextfield)) {
            IGuiNpcTextField textField;
            int id = GuiNpcTextField.activeTextfield.getID() + 1;
            if (id > (this.getTextField(9) != null ? 9 : 7)) {
                id = 5;
            }
            if ((textField = this.getTextField(id)) != null) {
                GuiNpcTextField.activeTextfield.unFocus();
                textField.setFocus(true);
                ((IGuiTextFieldMixin)((Object)textField)).npcs$setCursorPosition(0);
                ((IGuiTextFieldMixin)((Object)textField)).npcs$setSelectionEnd(textField.getFullText().length());
                GuiNpcTextField.activeTextfield = textField;
            }
        }
        super.func_73869_a(c, i);
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseBottom) {
        if (!this.hovered) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseBottom);
        if (this.hovered && mouseBottom == 0 && this.isMouseHover(mouseX, mouseY, this.guiLeft + 3, this.guiTop + 3, this.xSize - 3, 8)) {
            this.mousePressX = mouseX;
            this.mousePressY = mouseY;
            this.isMoving = true;
        }
    }

    @Override
    public void mouseEvent(int mouseX, int mouseY, int mouseBottom) {
        if (!this.hovered) {
            return;
        }
        super.mouseEvent(mouseX, mouseY, mouseBottom);
    }

    @Override
    public void func_146286_b(int mouseX, int mouseY, int mouseBottom) {
        if (!this.hovered) {
            return;
        }
        super.func_146286_b(mouseX, mouseY, mouseBottom);
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (!this.hovered) {
            return;
        }
        if (this.scrolls.containsKey(scroll.getID()) && this.parent instanceof ICustomScrollListener) {
            ((ICustomScrollListener)((Object)this.parent)).scrollClicked(mouseX, mouseY, mouseButton, scroll);
        }
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
        if (!this.hovered) {
            return;
        }
        if (this.scrolls.containsKey(scroll.getID()) && this.parent instanceof ICustomScrollListener) {
            ((ICustomScrollListener)((Object)this.parent)).scrollDoubleClicked(select, scroll);
        }
    }

    @Override
    public void mouseDragged(IGuiNpcSlider slider) {
        if (!this.hovered) {
            return;
        }
        if (this.sliders.containsKey(slider.getID())) {
            this.parent.mouseDragged(slider);
        }
    }

    @Override
    public void mousePressed(IGuiNpcSlider slider) {
        if (!this.hovered) {
            return;
        }
        if (this.sliders.containsKey(slider.getID())) {
            this.parent.mousePressed(slider);
        }
    }

    @Override
    public void mouseReleased(IGuiNpcSlider slider) {
        if (!this.hovered) {
            return;
        }
        if (this.sliders.containsKey(slider.getID())) {
            this.parent.mouseReleased(slider);
        }
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        if (this.textFields.containsKey(textField.getID())) {
            this.parent.unFocused(textField);
        }
    }

    public static void drawTopRect(int left, int top, int right, int bottom, float zLevel, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public void setPoint(IComponentGui component) {
        this.point = component;
    }

    public void setColorLine(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        this.colorLine = (red << 16) + (green << 8) + blue;
    }

    public int getColorLine() {
        return this.colorLine;
    }

    @Override
    public void resetButtons() {
        this.buttons.remove(2500);
        this.components.removeIf(c -> c instanceof GuiNpcButton && c.getID() == 2500);
        GuiNpcButton exit = new GuiNpcButton(2500, this.guiLeft + this.xSize - 12, this.guiTop + 3, 8, 8, "X");
        exit.setTexture(ANIMATION_BUTTONS);
        exit.setHasDefaultBack(false);
        exit.setIsAnim(true);
        exit.setTextureXY(232, 0);
        exit.setTextureUV(24, 24);
        exit.setLayerColor(new Color(-65536).getRGB());
        exit.setTextColor(new Color(-12566464).getRGB());
        this.addButton((IGuiNpcButton)exit);
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public int[] getCenter() {
        return new int[]{this.guiLeft + this.field_146294_l / 2, this.guiTop + this.field_146295_m / 2};
    }

    @Override
    public void setHoverText(String text, Object ... args) {
        this.hoverText.clear();
        if (text == null || text.isEmpty()) {
            return;
        }
        if (!text.contains("%")) {
            text = new TextComponentTranslation(text, args).func_150254_d();
        }
        if (text.contains("~~~")) {
            text = text.replaceAll("~~~", "%");
        }
        while (text.contains("<br>")) {
            this.hoverText.add(text.substring(0, text.indexOf("<br>")));
            text = text.substring(text.indexOf("<br>") + 4);
        }
        this.hoverText.add(text);
    }

    @Override
    public int getLeft() {
        return this.guiLeft;
    }

    @Override
    public int getTop() {
        return this.guiTop;
    }

    @Override
    public void setLeft(int left) {
        this.guiLeft = left;
    }

    @Override
    public void setTop(int top) {
        this.guiTop = top;
    }

    @Override
    public int getWidth() {
        return this.field_146294_l;
    }

    @Override
    public int getHeight() {
        return this.field_146295_m;
    }

    @Override
    public void customKeyTyped(char c, int id) {
        this.func_73869_a(c, id);
    }

    @Override
    public void customMouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.func_73864_a(mouseX, mouseY, mouseButton);
    }

    @Override
    public void customMouseReleased(int mouseX, int mouseY, int mouseButton) {
        this.func_146286_b(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setIsVisible(boolean bo) {
        this.visible = bo;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean bo) {
    }

    @Override
    public boolean isHovered() {
        return this.hovered;
    }
}

